package gov.va.vinci.dart.db;

import java.util.Date;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.ResearchStudy;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestResearchStudyDAO  extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		Assert.assertNull(DartObjectFactory.getInstance().getResearchStudyDAO().findById(0));
		
		try {
			ResearchStudy.create("short name", new Date(), new Date(), "Official Name - this is a test!", null);
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {
		}

		try {
			ResearchStudy.create("short name", new Date(), new Date(), "Official Name - this is a test!", "");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {
		}
		try {
			ResearchStudy.create("short name", new Date(), new Date(), "Official Name - this is a test!", "123456789012345678901234567890123456789012345678901234567890");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {
		}

		ResearchStudy study = ResearchStudy.create("short name", new Date(), new Date(), "Official Name - this is a test!", "DNS");
		Assert.assertNotNull(study);
		
		Assert.assertEquals(study.getName(), "short name");
		
		int newId = study.getId();
		
		ResearchStudy study2 = DartObjectFactory.getInstance().getResearchStudyDAO().findById(study.getId());
		Assert.assertNotNull(study2);
		Assert.assertEquals(study2.getName(), "short name");

		// update the short name and official name property
		study2.modify("new short name", study2.getStartDate(), study2.getEndDate(), "new official name", "modifier");

		ResearchStudy study3 = DartObjectFactory.getInstance().getResearchStudyDAO().findById(study.getId());
		Assert.assertNotNull(study3);
		Assert.assertEquals(study3.getName(), "new short name");
		Assert.assertEquals(study3.getOfficialName(), "new official name");

		ResearchStudy study4 = DartObjectFactory.getInstance().getResearchStudyDAO().findByShortName("new short name");
		Assert.assertNotNull(study4);
		Assert.assertEquals(study4.getName(), "new short name");
		Assert.assertEquals(study4.getOfficialName(), "new official name");
		
	}
	
}
